package GUI;


import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import baseClass.*;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 * @author Carlos Victor 
 */
public class JanelaFiltros implements MouseListener, ActionListener {

	private JFrame window = null;
	private JPanel panel1 = null;
	private JButton button2,button3,button4= null;
	private JLabel label1 = null;
	private Recomendacoes recomendacoes = null;
	private JTextArea txt = null;
	private Component comp = null; 
	private JLabel label6 = null;
	private JRadioButton radioButton1 = null;
	private JRadioButton radioButton2 = null;
	private ButtonGroup group = null;
	  
	/**
	 * Cria uma nova janela de sistema de recomendacoes
	 * @param opinioes
	 * 		O caminho do arquivo de opinioes.
	 * @param enderecos
	 * 		O caminho do arquivo de enderecos.
	 */
	public JanelaFiltros(Recomendacoes recomendacoes) {
		
		this.recomendacoes = recomendacoes;
		
		createWindow();
	}
	
	/**
	 * Criacao da janela.
	 */
	private void createWindow() {
		window = new JFrame();
		panel1 = new JPanel();
		button2 = new JButton("VOLTAR");
		button3 = new JButton("Ajuda");
		button4 = new JButton("CARREGAR");
		label1 = new JLabel("SEJA BEM VINDO AO SISTEMA DE RECOMEDAÇÕES.");
		label6 = new JLabel(); 
		txt = new JTextArea();
		comp = new JScrollPane(txt); 
		radioButton1 = new JRadioButton("Ordena por nome");
		radioButton2 = new JRadioButton("Ordena por tipo de refeição");
		group = new ButtonGroup();
			
		window.setSize(700, 600);
		window.setResizable(true);
		window.setMinimumSize(new Dimension(300, 200));
		window.setLocation(280, 60);
		window.setVisible(true);
		window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		label6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/image3101-v3.png")));
		label6.setLocation(0, -150);
		label6.setSize(550,470);
		label1.setLocation(340, -100);
		label1.setSize(300, 300);
		label1.setForeground(Color.WHITE);
		
		
		panel1.setVisible(true);
		panel1.setLayout(null);
		panel1.setBackground(Color.ORANGE);
		
		button2.setToolTipText("Voltar ao menu principal");
		button2.setEnabled(true);
		button2.addMouseListener(this);
		button2.addActionListener(this);
		button2.setSize(200,70);
		button2.setLocation(400, 400);
		button2.setForeground(Color.ORANGE);
		button2.setBackground(Color.WHITE);
		button3.setToolTipText("Tutorial sobre o sistema.");
		button3.setEnabled(true);
		button3.addMouseListener(this);
		button3.addActionListener(this);
		button3.setSize(100,20);
		button3.setLocation(434, 90);
		button3.setForeground(Color.ORANGE);
		button4.setToolTipText("Gerar estabelecimentos");
		button4.setEnabled(true);
		button4.addMouseListener(this);
		button4.addActionListener(this);
		button4.setSize(200,70);
		button4.setLocation(400,300);
		button4.setForeground(Color.ORANGE);
		button4.setBackground(Color.WHITE);
		
		
		radioButton1.setLocation(350, 200);
		radioButton1.setSize(150, 50);
		radioButton1.setBackground(Color.ORANGE);
		radioButton1.setForeground(Color.WHITE);
		radioButton2.setLocation(500, 200);
		radioButton2.setSize(200, 50);
		radioButton2.setBackground(Color.ORANGE);
		radioButton2.setForeground(Color.WHITE);
		group.add(radioButton1);
		group.add(radioButton2);
		
		comp.setSize(300, 400);
		comp.setLocation(20, 150);
		txt.setEnabled(false);
	
		
		panel1.add(label1);
		panel1.add(radioButton1);
		panel1.add(radioButton2);
		panel1.add(button2);
		panel1.add(button3);
		panel1.add(button4);
		panel1.add(label6);
		panel1.add(comp);
		window.add(panel1);
	}

	/**
	 * M�todos referentes ao MouseListenner
	 */
	public void mouseClicked(MouseEvent arg0) {
	}
	
	public void mouseEntered(MouseEvent arg0) {
	}
	
	public void mouseExited(MouseEvent arg0) {
	}

	public void mousePressed(MouseEvent arg0) {
	}

	public void mouseReleased(MouseEvent arg0) {
	}

	/**
	 * Metodo referente ao ActionListener
	 */
	public void actionPerformed(ActionEvent e) {
		
		if (e.getSource() == button2) {
			window.dispose();
			new MenuRecomendacoes(recomendacoes.getCaminhoArquivo2(), recomendacoes.getCaminhoArquivo1());
		}
		
		if (e.getSource() == button3) {
			JOptionPane.showMessageDialog(null, "FILTRAR RESTAURANTES\nESCOLHA UM TIPO DE ORDENAÇÃO E PRESSIONE CARREGAR PARA ORDENAR OS ESTABELECIMENTOS\nDE ACORDO COM O SEU GOSTO\nPRESSIONE VOLTAR PARA RETORNAR AO MENU DE RECOMENDAÇÕES");
		}
		
		if (e.getSource() == button4) {
			txt.setText("");
			if (radioButton1.isSelected()) {
				for (String restaurante : recomendacoes.ordenacaoAlfabetica()) {
					txt.append(restaurante + "\n");
				}
			}
			if (radioButton2.isSelected()) {
				for (String restaurante : recomendacoes.ordenacaoPorRefeicao()) {
					txt.append(restaurante + "\n");
				}
			}
		}
		

	
	}
}
